package com.bluesunrise.portal.portlets.ws;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

import org.apache.portals.bridges.common.GenericServletPortlet;
import org.apache.portals.messaging.PortletMessaging;

import com.bluesunrise.ws.finance.stockmarket.webservice.BaseQuote;
import com.bluesunrise.ws.finance.stockmarket.webservice.QuoteService;
import com.bluesunrise.ws.finance.stockmarket.webservice.QuoteServiceServiceLocator;


public class StockQuotePortlet extends GenericServletPortlet 
{
    private URL serviceURL = null;
    private QuoteServiceServiceLocator locator;
    
    private static final String QUOTES = "quotes";
    private static final String SYMBOLS = "symbols";
    
    
    public void doView(RenderRequest request, RenderResponse response)
            throws PortletException, IOException
    {
        response.setContentType("text/html");
        
        String symbols = (String) PortletMessaging.receive(request, SYMBOLS);
        if (symbols == null)
        {
            symbols = request.getPreferences().getValue(SYMBOLS, "");            
        }

        List quoteList = (List) PortletMessaging.receive(request, QUOTES);        
        if(quoteList == null)
        {
            // retrieve the quote list
            quoteList = retrieveStockQuotes(request, symbols);
        }
        
        request.setAttribute(QUOTES, quoteList);
        request.setAttribute(SYMBOLS, symbols);
        
        super.doView(request, response);
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) 
    throws PortletException, IOException
    {
        String symbols = actionRequest.getParameter(SYMBOLS);
        if(symbols != null)
        {
            retrieveStockQuotes(actionRequest, symbols);
        }
    }

    public List retrieveStockQuotes(PortletRequest request, String symbols)
    {
        String []stockSymbols = stringToArray(symbols, ", ");
        List quoteList = null;
        try
        {
            if (stockSymbols == null || stockSymbols.length == 0)
                return new ArrayList();
            
            QuoteService quoteService = locator.getQuoteService(serviceURL);
            BaseQuote[] quotes = quoteService.fullQuotes(stockSymbols);
            
            quoteList = Arrays.asList(quotes);
            
            // track the quotes and symbols
            PortletMessaging.publish(request, QUOTES, quoteList);
            PortletMessaging.publish(request, SYMBOLS, symbols);
            
            // store the preference
            if (request instanceof ActionRequest)
            {
                PortletPreferences prefs = request.getPreferences(); 
                prefs.setValue(SYMBOLS, symbols);
                prefs.store();
            }
        }
        catch(Exception e)
        {
            e.printStackTrace();
        }
        
        if (quoteList == null)
            quoteList = new ArrayList();        
        return quoteList;
    }
        
    public void init(PortletConfig config) throws PortletException 
    {
        super.init(config);

        String url = config.getInitParameter("service_url");
        if (url == null)
        {
            url = "http://www.bluesunrise.com/axis/services/QuoteService";
        }
        try
        {
            serviceURL = new URL(url);
            locator = new QuoteServiceServiceLocator();
            
        }
        catch (MalformedURLException e)
        {
            throw new PortletException("Failed to locate Quote Service: " + url, e);
        }
    }
    
    public String[] stringToArray(String str, String separators)
    {
        StringTokenizer tokenizer;
        String[] array = null;
        int count = 0;

        if (str == null)
            return array;

        if (separators == null)
            separators = ",";

        tokenizer = new StringTokenizer(str, separators);
        if ((count = tokenizer.countTokens()) <= 0) {
            return array;
        }
        
        array = new String[count];
        
        int ix = 0;
        while (tokenizer.hasMoreTokens()) 
        {
            array[ix] = tokenizer.nextToken();
            ix++;
        }

        return array;
    }
    
}